/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.timingdiagram.graphic;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.XPoint2D;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.ULine;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.timingdiagram.ChangeState;
import net.sourceforge.plantuml.timingdiagram.TimeConstraint;
import net.sourceforge.plantuml.timingdiagram.TimeTick;
import net.sourceforge.plantuml.timingdiagram.TimingNote;
import net.sourceforge.plantuml.timingdiagram.TimingRuler;
import net.sourceforge.plantuml.timingdiagram.graphic.IntricatedPoint;
import net.sourceforge.plantuml.timingdiagram.graphic.PanelsNoLeft;
import net.sourceforge.plantuml.utils.Position;

public class PanelsBinary
extends PanelsNoLeft {
    private static final String LOW_STRING = "0";
    private static final String HIGH_STRING = "1";
    private final SortedMap<TimeTick, ChangeState> values;
    private final ChangeState initialState;

    public PanelsBinary(TimingRuler ruler, ISkinParam skinParam, int suggestedHeight, Style style, SortedMap<TimeTick, ChangeState> values, List<TimeConstraint> constraints, ChangeState initialState, List<TimingNote> notes) {
        super(ruler, skinParam, suggestedHeight, style, notes, constraints);
        this.values = values;
        this.initialState = initialState;
    }

    @Override
    public double getFullHeight(StringBounder stringBounder) {
        return this.getHeightForConstraints(stringBounder) + this.getHeightForNotes(stringBounder, Position.TOP) + (double)this.suggestedHeight + this.getHeightForNotes(stringBounder, Position.BOTTOM);
    }

    @Override
    public IntricatedPoint getTimeProjection(StringBounder stringBounder, TimeTick tick) {
        if (tick == null) {
            return null;
        }
        double x = this.ruler.getPosInPixel(tick);
        return new IntricatedPoint(new XPoint2D(x, this.getYpos(stringBounder, HIGH_STRING)), new XPoint2D(x, this.getYpos(stringBounder, HIGH_STRING)));
    }

    private double getYpos(StringBounder stringBounder, String state) {
        if (state.equalsIgnoreCase(LOW_STRING)) {
            return this.getYlow(stringBounder);
        }
        return this.getYhigh(stringBounder);
    }

    private double getYhigh(StringBounder stringBounder) {
        return 8.0 + this.getHeightForConstraints(stringBounder) + this.getHeightForNotes(stringBounder, Position.TOP);
    }

    private double getYlow(StringBounder stringBounder) {
        return this.getHeightForConstraints(stringBounder) + this.getHeightForNotes(stringBounder, Position.TOP) + (double)this.suggestedHeight - 8.0;
    }

    @Override
    public void drawRightPanel(UGraphic ug) {
        ug = this.getContext().apply(ug);
        double lastx = 0.0;
        List<String> lastValues = this.initialState == null ? Collections.singletonList(LOW_STRING) : this.initialState.getStates();
        StringBounder stringBounder = ug.getStringBounder();
        double yhigh = this.getYhigh(stringBounder);
        double ylow = this.getYlow(stringBounder);
        ULine vline = ULine.vline(ylow - yhigh);
        for (Map.Entry<TimeTick, ChangeState> ent : this.values.entrySet()) {
            ChangeState value = ent.getValue();
            double x = this.ruler.getPosInPixel(ent.getKey());
            if (lastValues.size() == 1) {
                ug.apply(new UTranslate(lastx, this.getYpos(stringBounder, lastValues.get(0)))).draw(ULine.hline(x - lastx));
            } else {
                for (double tmpx = lastx; tmpx < x; tmpx += 5.0) {
                    ug.apply(new UTranslate(tmpx, yhigh)).draw(vline);
                }
            }
            if (!lastValues.equals(value.getStates())) {
                ug.apply(new UTranslate(x, yhigh)).draw(vline);
            }
            if (value.getComment() != null) {
                TextBlock label = this.getTextBlock(value.getComment());
                label.drawU(ug.apply(new UTranslate(x + 2.0, yhigh)));
            }
            lastx = x;
            lastValues = value.getStates();
        }
        ug.apply(new UTranslate(lastx, this.getYpos(stringBounder, lastValues.get(0)))).draw(ULine.hline(this.ruler.getWidth() - lastx));
        this.drawConstraints(ug.apply(UTranslate.dy(this.getHeightForConstraints(ug.getStringBounder()))));
        this.drawNotes(ug.apply(UTranslate.dy(8.0)), Position.TOP);
        this.drawNotes(ug.apply(UTranslate.dy(this.getHeightForConstraints(stringBounder) + this.getHeightForNotes(stringBounder, Position.TOP) + (double)this.suggestedHeight - 4.0)), Position.BOTTOM);
    }
}

