/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.dot;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.crash.ReportLog;
import net.sourceforge.plantuml.dot.ExeState;
import net.sourceforge.plantuml.dot.Graphviz;
import net.sourceforge.plantuml.dot.GraphvizRuntimeEnvironment;
import net.sourceforge.plantuml.dot.ProcessState;
import net.sourceforge.plantuml.log.Logme;
import net.sourceforge.plantuml.security.SecurityProfile;
import net.sourceforge.plantuml.security.SecurityUtils;

public class GraphvizUtils {
    private static int DOT_VERSION_LIMIT = 226;
    private static final ThreadLocal<Integer> limitSize = new ThreadLocal();

    public static void removeLocalLimitSize() {
        limitSize.remove();
    }

    public static void setLocalImageLimit(int value) {
        limitSize.set(value);
    }

    public static int getenvImageLimit() {
        Integer local = limitSize.get();
        if (local != null) {
            return local;
        }
        String env = SecurityUtils.getenv("PLANTUML_LIMIT_SIZE");
        if (StringUtils.isNotEmpty(env) && env.matches("\\d+")) {
            return Integer.parseInt(env);
        }
        return 4096;
    }

    public static String getenvDefaultConfigFilename() {
        return SecurityUtils.getenv("PLANTUML_DEFAULT_CONFIG_FILENAME");
    }

    public static String getenvLogData() {
        return SecurityUtils.getenv("PLANTUML_LOGDATA");
    }

    public static int addDotStatus(ReportLog result, boolean withRichText) {
        int error;
        block16: {
            ExeState exeState;
            String red = "";
            String bold = "";
            if (withRichText) {
                red = "<b><color:red>";
                bold = "<b>";
            }
            error = 0;
            if (GraphvizRuntimeEnvironment.getInstance().useVizJs(null)) {
                result.add("VizJs library is used!");
                try {
                    String err = GraphvizUtils.getTestCreateSimpleFile();
                    if (err == null) {
                        result.add(bold + "Installation seems OK. File generation OK");
                    } else {
                        result.add(red + err);
                    }
                }
                catch (Exception e) {
                    result.add(red + e.toString());
                    Logme.error(e);
                    error = 11;
                }
                return error;
            }
            File dotExe = GraphvizRuntimeEnvironment.getInstance().getDotExe();
            if (SecurityUtils.getSecurityProfile() == SecurityProfile.UNSECURE) {
                String ent = GraphvizRuntimeEnvironment.getInstance().getenvGraphvizDot();
                if (ent == null) {
                    result.add("The environment variable GRAPHVIZ_DOT has not been set");
                } else {
                    result.add("The environment variable GRAPHVIZ_DOT has been set to " + ent);
                }
                result.add("Dot executable is " + dotExe);
            }
            if ((exeState = ExeState.checkFile(dotExe)) == ExeState.OK) {
                try {
                    String version = GraphvizRuntimeEnvironment.getInstance().dotVersion();
                    result.add("Dot version: " + version);
                    int v = GraphvizRuntimeEnvironment.getInstance().getDotVersion();
                    if (v == -1) {
                        result.add("Warning : cannot determine dot version");
                        error = 12;
                        break block16;
                    }
                    if (v < DOT_VERSION_LIMIT) {
                        result.add(bold + "Warning : Your dot installation seems old");
                        result.add(bold + "Some diagrams may have issues");
                        error = 13;
                        break block16;
                    }
                    String err = GraphvizUtils.getTestCreateSimpleFile();
                    if (err == null) {
                        result.add(bold + "Installation seems OK. File generation OK");
                        break block16;
                    }
                    result.add(red + err);
                    error = 14;
                }
                catch (Exception e) {
                    result.add(red + e.toString());
                    Logme.error(e);
                    error = 15;
                }
            } else {
                result.add(red + "Error: " + exeState.getTextMessage());
                result.add("Error: only sequence diagrams will be generated");
                error = 16;
            }
        }
        return error;
    }

    static String getTestCreateSimpleFile() throws IOException {
        ByteArrayOutputStream baos;
        Graphviz graphviz2 = GraphvizRuntimeEnvironment.getInstance().create(null, "digraph foo { test; }", "svg");
        ProcessState state = graphviz2.createFile3(baos = new ByteArrayOutputStream());
        if (state.differs(ProcessState.TERMINATED_OK())) {
            return "Error: timeout " + state;
        }
        byte[] data = baos.toByteArray();
        if (data.length == 0) {
            return "Error: dot generates empty file. Check you dot installation.";
        }
        String s = new String(data);
        if (s.indexOf("<svg") == -1) {
            return "Error: dot generates unreadable SVG file. Check you dot installation.";
        }
        return null;
    }
}

