/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.chart;

import java.util.Map;

public class ChartAxis {
    private String title;
    private double min;
    private double max;
    private boolean autoScale;
    private Map<Double, String> customTicks;
    private Double tickSpacing;
    private LabelPosition labelPosition;

    public ChartAxis() {
        this.title = "";
        this.min = 0.0;
        this.max = 100.0;
        this.autoScale = true;
        this.customTicks = null;
        this.tickSpacing = null;
        this.labelPosition = LabelPosition.DEFAULT;
    }

    public ChartAxis(String title, double min, double max) {
        this.title = title;
        this.min = min;
        this.max = max;
        this.autoScale = false;
        this.customTicks = null;
        this.tickSpacing = null;
        this.labelPosition = LabelPosition.DEFAULT;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public double getMin() {
        return this.min;
    }

    public void setMin(double min) {
        this.min = min;
        this.autoScale = false;
    }

    public double getMax() {
        return this.max;
    }

    public void setMax(double max) {
        this.max = max;
        this.autoScale = false;
    }

    public boolean isAutoScale() {
        return this.autoScale;
    }

    public void setAutoScale(boolean autoScale) {
        this.autoScale = autoScale;
    }

    public double valueToPixel(double value, double pixelMin, double pixelMax) {
        if (this.max == this.min) {
            return pixelMin;
        }
        return pixelMin + (value - this.min) / (this.max - this.min) * (pixelMax - pixelMin);
    }

    public void includeValue(double value) {
        if (this.autoScale) {
            if (value < this.min) {
                this.min = value;
            }
            if (value > this.max) {
                this.max = value;
            }
        }
    }

    public Map<Double, String> getCustomTicks() {
        return this.customTicks;
    }

    public void setCustomTicks(Map<Double, String> customTicks) {
        this.customTicks = customTicks;
    }

    public boolean hasCustomTicks() {
        return this.customTicks != null && !this.customTicks.isEmpty();
    }

    public Double getTickSpacing() {
        return this.tickSpacing;
    }

    public void setTickSpacing(Double tickSpacing) {
        this.tickSpacing = tickSpacing;
    }

    public boolean hasTickSpacing() {
        return this.tickSpacing != null && this.tickSpacing > 0.0;
    }

    public LabelPosition getLabelPosition() {
        return this.labelPosition;
    }

    public void setLabelPosition(LabelPosition labelPosition) {
        this.labelPosition = labelPosition;
    }

    public static enum LabelPosition {
        DEFAULT,
        TOP,
        RIGHT;

    }
}

