/*
 * Decompiled with CFR 0.152.
 */
package KdfCtr_Compile;

import BoundedInts_Compile.uint8;
import HMAC.HMac;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import dafny.DafnyEuclidean;
import dafny.DafnySequence;
import dafny.TypeDescriptor;
import java.util.Objects;
import software.amazon.cryptography.primitives.internaldafny.types.DigestAlgorithm;
import software.amazon.cryptography.primitives.internaldafny.types.Error;
import software.amazon.cryptography.primitives.internaldafny.types.KdfCtrInput;

public class __default {
    public static Result<DafnySequence<? extends Byte>, Error> KdfCounterMode(KdfCtrInput input) {
        Result<DafnySequence<? extends Byte>, Error> output = Result.Default(DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), DafnySequence.empty(uint8._typeDescriptor()));
        Outcome<Error> _0_valueOrError0 = Outcome.Default(Error._typeDescriptor());
        _0_valueOrError0 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), !(!Objects.equals(input.dtor_digestAlgorithm(), DigestAlgorithm.create_SHA__256()) && !Objects.equals(input.dtor_digestAlgorithm(), DigestAlgorithm.create_SHA__384()) || (long)input.dtor_ikm().cardinalityInt() != 32L && (long)input.dtor_ikm().cardinalityInt() != 48L && (long)input.dtor_ikm().cardinalityInt() != 66L || !input.dtor_nonce().is_Some() || (long)input.dtor_nonce().dtor_value().cardinalityInt() != 16L && (long)input.dtor_nonce().dtor_value().cardinalityInt() != 32L || input.dtor_expectedLength() != 32 && input.dtor_expectedLength() != 64 || !((long)(input.dtor_expectedLength() * 8) != 0L) || Long.compareUnsigned(input.dtor_expectedLength() * 8, StandardLibrary_mUInt_Compile.__default.INT32__MAX__LIMIT().longValue()) >= 0), Error.create_AwsCryptographicPrimitivesError((DafnySequence<? extends Character>)DafnySequence.asString((String)"Kdf in Counter Mode input is invalid.")));
        if (_0_valueOrError0.IsFailure(Error._typeDescriptor())) {
            output = _0_valueOrError0.PropagateFailure(Error._typeDescriptor(), DafnySequence._typeDescriptor(uint8._typeDescriptor()));
            return output;
        }
        DafnySequence<? extends Byte> _1_ikm = input.dtor_ikm();
        DafnySequence<? extends Byte> _2_label__ = input.dtor_purpose().UnwrapOr((TypeDescriptor<DafnySequence<? extends Byte>>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), (DafnySequence<? extends Byte>)DafnySequence.empty(uint8._typeDescriptor()));
        DafnySequence<? extends Byte> _3_info = input.dtor_nonce().UnwrapOr((TypeDescriptor<DafnySequence<? extends Byte>>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), (DafnySequence<? extends Byte>)DafnySequence.empty(uint8._typeDescriptor()));
        DafnySequence _4_okm = DafnySequence.empty(uint8._typeDescriptor());
        int _5_internalLength = (int)(4L + (long)__default.SEPARATION__INDICATOR().cardinalityInt() + 4L);
        Outcome<Error> _6_valueOrError1 = Outcome.Default(Error._typeDescriptor());
        _6_valueOrError1 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), Long.compareUnsigned(StandardLibrary_mMemoryMath_Compile.__default.Add3(Integer.toUnsignedLong(_5_internalLength), _2_label__.cardinalityInt(), _3_info.cardinalityInt()), StandardLibrary_mUInt_Compile.__default.INT32__MAX__LIMIT().longValue()) < 0, Error.create_AwsCryptographicPrimitivesError((DafnySequence<? extends Character>)DafnySequence.asString((String)"Input Length exceeds INT32_MAX_LIMIT")));
        if (_6_valueOrError1.IsFailure(Error._typeDescriptor())) {
            output = _6_valueOrError1.PropagateFailure(Error._typeDescriptor(), DafnySequence._typeDescriptor(uint8._typeDescriptor()));
            return output;
        }
        DafnySequence<? extends Byte> _7_lengthBits = StandardLibrary_mUInt_Compile.__default.UInt32ToSeq(input.dtor_expectedLength() * 8);
        DafnySequence _8_explicitInfo = DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate(_2_label__, __default.SEPARATION__INDICATOR()), _3_info), _7_lengthBits);
        Outcome<Error> _9_valueOrError2 = Outcome.Default(Error._typeDescriptor());
        _9_valueOrError2 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), Long.compareUnsigned(4L + (long)_8_explicitInfo.cardinalityInt(), StandardLibrary_mUInt_Compile.__default.INT32__MAX__LIMIT().longValue()) < 0, Error.create_AwsCryptographicPrimitivesError((DafnySequence<? extends Character>)DafnySequence.asString((String)"PRF input length exceeds INT32_MAX_LIMIT.")));
        if (_9_valueOrError2.IsFailure(Error._typeDescriptor())) {
            output = _9_valueOrError2.PropagateFailure(Error._typeDescriptor(), DafnySequence._typeDescriptor(uint8._typeDescriptor()));
            return output;
        }
        Result<DafnySequence, Error> _10_valueOrError3 = Result.Default(DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), DafnySequence.empty(uint8._typeDescriptor()));
        Result<DafnySequence<? extends Byte>, Error> _out0 = __default.RawDerive(_1_ikm, (DafnySequence<? extends Byte>)_8_explicitInfo, input.dtor_expectedLength(), 0, input.dtor_digestAlgorithm());
        _10_valueOrError3 = _out0;
        if (_10_valueOrError3.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor())) {
            output = _10_valueOrError3.PropagateFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), DafnySequence._typeDescriptor(uint8._typeDescriptor()));
            return output;
        }
        _4_okm = _10_valueOrError3.Extract((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor());
        output = Result.create_Success(DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), _4_okm);
        return output;
    }

    public static Result<DafnySequence<? extends Byte>, Error> RawDerive(DafnySequence<? extends Byte> ikm, DafnySequence<? extends Byte> explicitInfo, int length, int offset, DigestAlgorithm digestAlgorithm) {
        Result<DafnySequence<? extends Byte>, Error> output = Result.Default(DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), DafnySequence.empty(uint8._typeDescriptor()));
        Result<HMac, Error> _0_valueOrError0 = null;
        Result<HMac, Error> _out0 = HMac.Build(digestAlgorithm);
        _0_valueOrError0 = _out0;
        if (_0_valueOrError0.IsFailure((TypeDescriptor<HMac>)TypeDescriptor.reference(HMac.class), Error._typeDescriptor())) {
            output = _0_valueOrError0.PropagateFailure((TypeDescriptor<HMac>)TypeDescriptor.reference(HMac.class), Error._typeDescriptor(), DafnySequence._typeDescriptor(uint8._typeDescriptor()));
            return output;
        }
        HMac _1_hmac = _0_valueOrError0.Extract((TypeDescriptor<HMac>)TypeDescriptor.reference(HMac.class), Error._typeDescriptor());
        _1_hmac.Init(ikm);
        int _2_macLengthBytes = (int)Digest_Compile.__default.Length(digestAlgorithm);
        int _3_iterations = DafnyEuclidean.EuclideanDivision((int)(length + _2_macLengthBytes - 1), (int)_2_macLengthBytes);
        DafnySequence _4_buffer = DafnySequence.empty(uint8._typeDescriptor());
        DafnySequence _5_i = StandardLibrary_mUInt_Compile.__default.UInt32ToSeq(__default.COUNTER__START__VALUE());
        long _hi0 = StandardLibrary_mMemoryMath_Compile.__default.Add(_3_iterations, 1L);
        long _6_iteration = 1L;
        while (Long.compareUnsigned(_6_iteration, _hi0) < 0) {
            DafnySequence<? extends Byte> _out1;
            _1_hmac.BlockUpdate(_5_i);
            _1_hmac.BlockUpdate(explicitInfo);
            DafnySequence<? extends Byte> _7_tmp = _out1 = _1_hmac.GetResult();
            _4_buffer = DafnySequence.concatenate((DafnySequence)_4_buffer, _7_tmp);
            Result<DafnySequence, Error> _8_valueOrError1 = Result.Default(DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), DafnySequence.empty(uint8._typeDescriptor()));
            _8_valueOrError1 = __default.Increment(_5_i);
            if (_8_valueOrError1.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor())) {
                output = _8_valueOrError1.PropagateFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), DafnySequence._typeDescriptor(uint8._typeDescriptor()));
                return output;
            }
            _5_i = _8_valueOrError1.Extract((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor());
            ++_6_iteration;
        }
        Outcome<Error> _9_valueOrError2 = Outcome.Default(Error._typeDescriptor());
        _9_valueOrError2 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), Long.compareUnsigned(_4_buffer.cardinalityInt(), length) >= 0, Error.create_AwsCryptographicPrimitivesError((DafnySequence<? extends Character>)DafnySequence.asString((String)"Failed to derive key of requested length")));
        if (_9_valueOrError2.IsFailure(Error._typeDescriptor())) {
            output = _9_valueOrError2.PropagateFailure(Error._typeDescriptor(), DafnySequence._typeDescriptor(uint8._typeDescriptor()));
            return output;
        }
        output = Result.create_Success(DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), _4_buffer.take(length));
        return output;
    }

    public static Result<DafnySequence<? extends Byte>, Error> Increment(DafnySequence<? extends Byte> x) {
        if (Integer.compareUnsigned(((Byte)x.select(3)).byteValue(), -1) < 0) {
            return Result.create_Success(DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), DafnySequence.of((byte[])new byte[]{(Byte)x.select(0), (Byte)x.select(1), (Byte)x.select(2), (byte)((Byte)x.select(3) + 1)}));
        }
        if (Integer.compareUnsigned(((Byte)x.select(2)).byteValue(), -1) < 0) {
            return Result.create_Success(DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), DafnySequence.of((byte[])new byte[]{(Byte)x.select(0), (Byte)x.select(1), (byte)((Byte)x.select(2) + 1), 0}));
        }
        if (Integer.compareUnsigned(((Byte)x.select(1)).byteValue(), -1) < 0) {
            return Result.create_Success(DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), DafnySequence.of((byte[])new byte[]{(Byte)x.select(0), (byte)((Byte)x.select(1) + 1), 0, 0}));
        }
        if (Integer.compareUnsigned(((Byte)x.select(0)).byteValue(), -1) < 0) {
            return Result.create_Success(DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), DafnySequence.of((byte[])new byte[]{(byte)((Byte)x.select(0) + 1), 0, 0, 0}));
        }
        return Result.create_Failure(DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), Error.create_AwsCryptographicPrimitivesError((DafnySequence<? extends Character>)DafnySequence.asString((String)"Unable to derive key material; may have exceeded limit.")));
    }

    public static DafnySequence<? extends Byte> SEPARATION__INDICATOR() {
        return DafnySequence.of((byte[])new byte[]{0});
    }

    public static int COUNTER__START__VALUE() {
        return 1;
    }

    public String toString() {
        return "KdfCtr._default";
    }
}

