/*
 * Decompiled with CFR 0.152.
 */
package jogamp.newt.driver.x11;

import com.jogamp.common.nio.Buffers;
import com.jogamp.nativewindow.AbstractGraphicsDevice;
import com.jogamp.nativewindow.NativeWindowException;
import com.jogamp.nativewindow.util.PixelFormat;
import com.jogamp.nativewindow.x11.X11GraphicsDevice;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import jogamp.nativewindow.x11.X11Util;
import jogamp.newt.DisplayImpl;
import jogamp.newt.NEWTJNILibLoader;
import jogamp.newt.driver.x11.RandR;
import jogamp.newt.driver.x11.WindowDriver;

public class DisplayDriver
extends DisplayImpl {
    private long windowDeleteAtom;
    private long javaObjectAtom;
    private int randr_event_base;
    private int randr_error_base;
    private int xi_opcode;
    private RandR rAndR;

    static void initSingleton() {
    }

    @Override
    public String validateDisplayName(String string, long l) {
        return X11Util.validateDisplayName(string, l);
    }

    @Override
    protected void createNativeImpl() {
        X11Util.setX11ErrorHandler(true, !DEBUG);
        long l = X11Util.openDisplay(this.name);
        if (0L == l) {
            throw new RuntimeException("Error creating display(Win): " + this.name);
        }
        this.aDevice = new X11GraphicsDevice(l, 0, true);
        try {
            this.CompleteDisplay0(this.aDevice.getHandle());
        }
        catch (RuntimeException runtimeException) {
            this.closeNativeImpl(this.aDevice);
            throw runtimeException;
        }
    }

    @Override
    protected void closeNativeImpl(AbstractGraphicsDevice abstractGraphicsDevice) {
        this.DisplayRelease0(abstractGraphicsDevice.getHandle(), this.javaObjectAtom, this.windowDeleteAtom);
        this.javaObjectAtom = 0L;
        this.windowDeleteAtom = 0L;
        abstractGraphicsDevice.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dispatchMessagesNative() {
        AbstractGraphicsDevice abstractGraphicsDevice = this.aDevice;
        abstractGraphicsDevice.lock();
        try {
            long l = abstractGraphicsDevice.getHandle();
            if (0L != l) {
                this.DispatchMessages0(l, this.javaObjectAtom, this.windowDeleteAtom, this.randr_event_base, this.randr_error_base, this.xi_opcode);
            }
        }
        finally {
            abstractGraphicsDevice.unlock();
        }
    }

    protected long getJavaObjectAtom() {
        return this.javaObjectAtom;
    }

    protected long getWindowDeleteAtom() {
        return this.windowDeleteAtom;
    }

    protected int getRandREventBase() {
        return this.randr_event_base;
    }

    protected int getRandRErrorBase() {
        return this.randr_error_base;
    }

    protected int getXiOpcode() {
        return this.xi_opcode;
    }

    protected Boolean isXineramaEnabled() {
        return this.isNativeValid() ? Boolean.valueOf(((X11GraphicsDevice)this.aDevice).isXineramaEnabled()) : null;
    }

    @Override
    protected final long createPointerIconImpl(PixelFormat pixelFormat, int n, int n2, ByteBuffer byteBuffer, int n3, int n4) {
        return DisplayDriver.createPointerIcon(this.getHandle(), byteBuffer, n, n2, n3, n4);
    }

    @Override
    protected final void destroyPointerIconImpl(long l, long l2) {
        DisplayDriver.destroyPointerIcon0(l, l2);
    }

    private static native boolean initIDs0(boolean var0);

    private native void CompleteDisplay0(long var1);

    private void displayCompleted(long l, long l2, int n, int n2, int n3) {
        this.javaObjectAtom = l;
        this.windowDeleteAtom = l2;
        this.randr_event_base = n;
        this.randr_error_base = n2;
        this.xi_opcode = n3;
    }

    private boolean sendRRScreenChangeNotify(long l) {
        if (null != this.rAndR) {
            this.rAndR.sendRRScreenChangeNotify(this.getHandle(), l);
        }
        return this.isNativeValidAsync();
    }

    void registerRandR(RandR randR) {
        this.rAndR = randR;
    }

    private native void DisplayRelease0(long var1, long var3, long var5);

    private native void DispatchMessages0(long var1, long var3, long var5, int var7, int var8, int var9);

    private static long createPointerIcon(long l, Buffer buffer, int n, int n2, int n3, int n4) {
        boolean bl = Buffers.isDirect((Object)buffer);
        return DisplayDriver.createPointerIcon0(l, bl ? buffer : Buffers.getArray((Object)buffer), bl ? Buffers.getDirectBufferByteOffset((Object)buffer) : Buffers.getIndirectBufferByteOffset((Object)buffer), bl, n, n2, n3, n4);
    }

    private static native long createPointerIcon0(long var0, Object var2, int var3, boolean var4, int var5, int var6, int var7, int var8);

    private static native void destroyPointerIcon0(long var0, long var2);

    static {
        NEWTJNILibLoader.loadNEWTHead();
        if (!DisplayDriver.initIDs0(X11Util.XERROR_STACKDUMP)) {
            throw new NativeWindowException("Failed to initialize X11Display jmethodIDs");
        }
        if (!WindowDriver.initIDs0()) {
            throw new NativeWindowException("Failed to initialize X11Window jmethodIDs");
        }
    }
}

