/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.data.storage;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.app.DBPPlatform;
import org.jkiss.dbeaver.model.data.DBDContentStorage;
import org.jkiss.dbeaver.model.data.storage.TemporaryContentStorage;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.utils.ContentUtils;

public class ExternalContentStorage
implements DBDContentStorage {
    @NotNull
    private final DBPPlatform platform;
    @NotNull
    private Path file;
    private String charset;

    public ExternalContentStorage(@NotNull DBPPlatform platform, @NotNull Path file) {
        this(platform, file, null);
    }

    public ExternalContentStorage(@NotNull DBPPlatform platform, @NotNull Path file, String charset) {
        this.platform = platform;
        this.file = file;
        this.charset = charset;
    }

    @NotNull
    public Path getFile() {
        return this.file;
    }

    @Override
    @NotNull
    public InputStream getContentStream() throws IOException {
        return Files.newInputStream(this.file, new OpenOption[0]);
    }

    @Override
    @NotNull
    public Reader getContentReader() throws IOException {
        if (this.charset == null) {
            return Files.newBufferedReader(this.file, StandardCharsets.UTF_8);
        }
        return Files.newBufferedReader(this.file, Charset.forName(this.charset));
    }

    @Override
    public long getContentLength() throws IOException {
        return Files.size(this.file);
    }

    @Override
    public String getCharset() {
        return this.charset;
    }

    @Override
    public DBDContentStorage cloneStorage(DBRProgressMonitor monitor) throws IOException {
        Path tempFile = ContentUtils.createTempContentFile(monitor, this.platform, "copy" + this.hashCode());
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (InputStream is = Files.newInputStream(this.file, new OpenOption[0]);){
                Throwable throwable2 = null;
                Object var7_11 = null;
                try (OutputStream os = Files.newOutputStream(tempFile, new OpenOption[0]);){
                    ContentUtils.copyStreams(is, Files.size(this.file), os, monitor);
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            ContentUtils.deleteTempFile(tempFile);
            throw new IOException(e);
        }
        return new TemporaryContentStorage(this.platform, tempFile, this.charset, true);
    }

    @Override
    public void release() {
    }
}

