﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/waf-regional/WAFRegional_EXPORTS.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace WAFRegional {
namespace Model {
class CreateWebACLMigrationStackResult {
 public:
  AWS_WAFREGIONAL_API CreateWebACLMigrationStackResult() = default;
  AWS_WAFREGIONAL_API CreateWebACLMigrationStackResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_WAFREGIONAL_API CreateWebACLMigrationStackResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The URL of the template created in Amazon S3. </p>
   */
  inline const Aws::String& GetS3ObjectUrl() const { return m_s3ObjectUrl; }
  template <typename S3ObjectUrlT = Aws::String>
  void SetS3ObjectUrl(S3ObjectUrlT&& value) {
    m_s3ObjectUrlHasBeenSet = true;
    m_s3ObjectUrl = std::forward<S3ObjectUrlT>(value);
  }
  template <typename S3ObjectUrlT = Aws::String>
  CreateWebACLMigrationStackResult& WithS3ObjectUrl(S3ObjectUrlT&& value) {
    SetS3ObjectUrl(std::forward<S3ObjectUrlT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  CreateWebACLMigrationStackResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_s3ObjectUrl;

  Aws::String m_requestId;
  bool m_s3ObjectUrlHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace WAFRegional
}  // namespace Aws
