﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/outposts/OutpostsRequest.h>
#include <aws/outposts/Outposts_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Http {
class URI;
}  // namespace Http
namespace Outposts {
namespace Model {

/**
 */
class ListBlockingInstancesForCapacityTaskRequest : public OutpostsRequest {
 public:
  AWS_OUTPOSTS_API ListBlockingInstancesForCapacityTaskRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "ListBlockingInstancesForCapacityTask"; }

  AWS_OUTPOSTS_API Aws::String SerializePayload() const override;

  AWS_OUTPOSTS_API void AddQueryStringParameters(Aws::Http::URI& uri) const override;

  ///@{
  /**
   * <p>The ID or ARN of the Outpost associated with the specified capacity task.</p>
   */
  inline const Aws::String& GetOutpostIdentifier() const { return m_outpostIdentifier; }
  inline bool OutpostIdentifierHasBeenSet() const { return m_outpostIdentifierHasBeenSet; }
  template <typename OutpostIdentifierT = Aws::String>
  void SetOutpostIdentifier(OutpostIdentifierT&& value) {
    m_outpostIdentifierHasBeenSet = true;
    m_outpostIdentifier = std::forward<OutpostIdentifierT>(value);
  }
  template <typename OutpostIdentifierT = Aws::String>
  ListBlockingInstancesForCapacityTaskRequest& WithOutpostIdentifier(OutpostIdentifierT&& value) {
    SetOutpostIdentifier(std::forward<OutpostIdentifierT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ID of the capacity task.</p>
   */
  inline const Aws::String& GetCapacityTaskId() const { return m_capacityTaskId; }
  inline bool CapacityTaskIdHasBeenSet() const { return m_capacityTaskIdHasBeenSet; }
  template <typename CapacityTaskIdT = Aws::String>
  void SetCapacityTaskId(CapacityTaskIdT&& value) {
    m_capacityTaskIdHasBeenSet = true;
    m_capacityTaskId = std::forward<CapacityTaskIdT>(value);
  }
  template <typename CapacityTaskIdT = Aws::String>
  ListBlockingInstancesForCapacityTaskRequest& WithCapacityTaskId(CapacityTaskIdT&& value) {
    SetCapacityTaskId(std::forward<CapacityTaskIdT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline int GetMaxResults() const { return m_maxResults; }
  inline bool MaxResultsHasBeenSet() const { return m_maxResultsHasBeenSet; }
  inline void SetMaxResults(int value) {
    m_maxResultsHasBeenSet = true;
    m_maxResults = value;
  }
  inline ListBlockingInstancesForCapacityTaskRequest& WithMaxResults(int value) {
    SetMaxResults(value);
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  inline bool NextTokenHasBeenSet() const { return m_nextTokenHasBeenSet; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListBlockingInstancesForCapacityTaskRequest& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_outpostIdentifier;

  Aws::String m_capacityTaskId;

  int m_maxResults{0};

  Aws::String m_nextToken;
  bool m_outpostIdentifierHasBeenSet = false;
  bool m_capacityTaskIdHasBeenSet = false;
  bool m_maxResultsHasBeenSet = false;
  bool m_nextTokenHasBeenSet = false;
};

}  // namespace Model
}  // namespace Outposts
}  // namespace Aws
