/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.vfs.impl.jar;

import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.util.Pair;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.DeprecatedVirtualFileSystem;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.impl.jar.CoreJarHandler;
import org.jetbrains.kotlin.com.intellij.util.containers.ConcurrentFactoryMap;

public final class CoreJarFileSystem
extends DeprecatedVirtualFileSystem {
    private final Map<String, CoreJarHandler> myHandlers = ConcurrentFactoryMap.createMap(key -> new CoreJarHandler(this, (String)key));

    @Override
    @NotNull
    public String getProtocol() {
        return "jar";
    }

    @Override
    public VirtualFile findFileByPath(@NotNull String path) {
        if (path == null) {
            CoreJarFileSystem.$$$reportNull$$$0(0);
        }
        Pair<String, String> pair = CoreJarFileSystem.splitPath(path);
        return this.myHandlers.get(pair.first).findFileByPath((String)pair.second);
    }

    @NotNull
    static Pair<String, String> splitPath(@NotNull String path) {
        int separator;
        if (path == null) {
            CoreJarFileSystem.$$$reportNull$$$0(1);
        }
        if ((separator = path.indexOf("!/")) < 0) {
            throw new IllegalArgumentException("Path in JarFileSystem must contain a separator: " + path);
        }
        Pair<String, String> pair = Pair.pair(path.substring(0, separator), path.substring(separator + "!/".length()));
        if (pair == null) {
            CoreJarFileSystem.$$$reportNull$$$0(2);
        }
        return pair;
    }

    @Override
    public void refresh(boolean asynchronous) {
    }

    @Override
    public VirtualFile refreshAndFindFileByPath(@NotNull String path) {
        if (path == null) {
            CoreJarFileSystem.$$$reportNull$$$0(3);
        }
        return this.findFileByPath(path);
    }

    public void clearHandlersCache() {
        this.myHandlers.forEach((path, handler2) -> handler2.clearCaches());
        this.myHandlers.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/openapi/vfs/impl/jar/CoreJarFileSystem";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/vfs/impl/jar/CoreJarFileSystem";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "splitPath";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findFileByPath";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "splitPath";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "refreshAndFindFileByPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

