#!/usr/bin/bash
#
#   lint_pkgbuild.sh - functions for detecting PKGBUILD errors
#
#   Copyright (c) 2015-2025 Pacman Development Team <pacman-dev@lists.archlinux.org>
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

[[ -n "$LIBMAKEPKG_LINT_PKGBUILD_SH" ]] && return
LIBMAKEPKG_LINT_PKGBUILD_SH=1

MAKEPKG_LIBRARY=${MAKEPKG_LIBRARY:-'/usr/share/makepkg'}

source "$MAKEPKG_LIBRARY/util/message.sh"


declare -a lint_pkgbuild_functions

for lib in "$MAKEPKG_LIBRARY/lint_pkgbuild/"*.sh; do
	source "$lib"
done

readonly -a lint_pkgbuild_functions


lint_pkgbuild() {
	local ret=0

	for func in ${lint_pkgbuild_functions[@]}; do
		$func || ret=1
	done

	return $ret
}
