﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/mediapackagev2/Mediapackagev2Request.h>
#include <aws/mediapackagev2/Mediapackagev2_EXPORTS.h>

#include <utility>

namespace Aws {
namespace mediapackagev2 {
namespace Model {

/**
 */
class DeleteChannelRequest : public Mediapackagev2Request {
 public:
  AWS_MEDIAPACKAGEV2_API DeleteChannelRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "DeleteChannel"; }

  AWS_MEDIAPACKAGEV2_API Aws::String SerializePayload() const override;

  ///@{
  /**
   * <p>The name that describes the channel group. The name is the primary identifier
   * for the channel group, and must be unique for your account in the AWS
   * Region.</p>
   */
  inline const Aws::String& GetChannelGroupName() const { return m_channelGroupName; }
  inline bool ChannelGroupNameHasBeenSet() const { return m_channelGroupNameHasBeenSet; }
  template <typename ChannelGroupNameT = Aws::String>
  void SetChannelGroupName(ChannelGroupNameT&& value) {
    m_channelGroupNameHasBeenSet = true;
    m_channelGroupName = std::forward<ChannelGroupNameT>(value);
  }
  template <typename ChannelGroupNameT = Aws::String>
  DeleteChannelRequest& WithChannelGroupName(ChannelGroupNameT&& value) {
    SetChannelGroupName(std::forward<ChannelGroupNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name that describes the channel. The name is the primary identifier for
   * the channel, and must be unique for your account in the AWS Region and channel
   * group.</p>
   */
  inline const Aws::String& GetChannelName() const { return m_channelName; }
  inline bool ChannelNameHasBeenSet() const { return m_channelNameHasBeenSet; }
  template <typename ChannelNameT = Aws::String>
  void SetChannelName(ChannelNameT&& value) {
    m_channelNameHasBeenSet = true;
    m_channelName = std::forward<ChannelNameT>(value);
  }
  template <typename ChannelNameT = Aws::String>
  DeleteChannelRequest& WithChannelName(ChannelNameT&& value) {
    SetChannelName(std::forward<ChannelNameT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_channelGroupName;
  bool m_channelGroupNameHasBeenSet = false;

  Aws::String m_channelName;
  bool m_channelNameHasBeenSet = false;
};

}  // namespace Model
}  // namespace mediapackagev2
}  // namespace Aws
