﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/iotsitewise/IoTSiteWise_EXPORTS.h>
#include <aws/iotsitewise/model/Content.h>
#include <aws/iotsitewise/model/Reference.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace IoTSiteWise {
namespace Model {

/**
 * <p>Contains text content to which the SiteWise Assistant refers to, and generate
 * the final response. It also contains information about the source.</p><p><h3>See
 * Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/Citation">AWS
 * API Reference</a></p>
 */
class Citation {
 public:
  AWS_IOTSITEWISE_API Citation() = default;
  AWS_IOTSITEWISE_API Citation(Aws::Utils::Json::JsonView jsonValue);
  AWS_IOTSITEWISE_API Citation& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_IOTSITEWISE_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>Contains information about the data source.</p>
   */
  inline const Reference& GetReference() const { return m_reference; }
  inline bool ReferenceHasBeenSet() const { return m_referenceHasBeenSet; }
  template <typename ReferenceT = Reference>
  void SetReference(ReferenceT&& value) {
    m_referenceHasBeenSet = true;
    m_reference = std::forward<ReferenceT>(value);
  }
  template <typename ReferenceT = Reference>
  Citation& WithReference(ReferenceT&& value) {
    SetReference(std::forward<ReferenceT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Contains the cited text from the data source.</p>
   */
  inline const Content& GetContent() const { return m_content; }
  inline bool ContentHasBeenSet() const { return m_contentHasBeenSet; }
  template <typename ContentT = Content>
  void SetContent(ContentT&& value) {
    m_contentHasBeenSet = true;
    m_content = std::forward<ContentT>(value);
  }
  template <typename ContentT = Content>
  Citation& WithContent(ContentT&& value) {
    SetContent(std::forward<ContentT>(value));
    return *this;
  }
  ///@}
 private:
  Reference m_reference;
  bool m_referenceHasBeenSet = false;

  Content m_content;
  bool m_contentHasBeenSet = false;
};

}  // namespace Model
}  // namespace IoTSiteWise
}  // namespace Aws
