/*=========================================================================
*
*  Copyright NumFOCUS
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkIsolatedConnectedImageFilter_h
#define sitkIsolatedConnectedImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk::simple {

    /**\class IsolatedConnectedImageFilter
\brief Label pixels that are connected to one set of seeds but not another.

IsolatedConnectedImageFilter finds the optimal threshold to separate two regions. It has two modes, one to separate dark regions surrounded by bright regions by automatically finding a minimum isolating upper threshold, and another to separate bright regions surrounded by dark regions by automatically finding a maximum lower isolating threshold. The mode can be chosen by setting FindUpperThresholdOn() /Off(). In both cases, the isolating threshold is retrieved with GetIsolatedValue() .

The algorithm labels pixels with ReplaceValue that are connected to Seeds1 AND NOT connected to Seeds2. When finding the threshold to separate two dark regions surrounded by bright regions, given a fixed lower threshold, the filter adjusts the upper threshold until the two sets of seeds are not connected. The algorithm uses a binary search to adjust the upper threshold, starting at Upper. The reverse is true for finding the threshold to separate two bright regions. Lower defaults to the smallest possible value for the InputImagePixelType, and Upper defaults to the largest possible value for the InputImagePixelType.

The user can also supply the Lower and Upper values to restrict the search. However, if the range is too restrictive, it could happen that no isolating threshold can be found between the user specified Lower and Upper values. Therefore, unless the user is sure of the bounds to set, it is recommended that the user set these values to the lowest and highest intensity values in the image, respectively.

The user can specify more than one seed for both regions to separate. The algorithm will try find the threshold that ensures that all of the first seeds are contained in the resulting segmentation and all of the second seeds are not contained in the segmentation.

It is possible that the algorithm may not be able to find the isolating threshold because no such threshold exists. The user can check for this by querying the GetThresholdingFailed() flag.
\sa itk::simple::IsolatedConnected for the procedural interface
\sa itk::IsolatedConnectedImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT IsolatedConnectedImageFilter : public ImageFilter {
    public:
      using Self = IsolatedConnectedImageFilter;

      /** Destructor */
      virtual ~IsolatedConnectedImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      IsolatedConnectedImageFilter();

      /** Define the pixels types supported by this filter */
      using PixelIDTypeList = BasicPixelIDTypeList;
\

      /**
       * Set a single seed point 1.

This seed will be isolated from Seed2 (if possible). All pixels connected to this seed will be replaced with ReplaceValue.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetSeed1 ( std::vector<unsigned int> Seed1 ) { this->m_Seed1 = std::move(Seed1); return *this; }

      /**
       */
      std::vector<unsigned int> GetSeed1() const { return this->m_Seed1; }\

      /**
       * Set a single seed point 2.

This seed will be isolated from Seed1 (if possible).
       */
      SITK_RETURN_SELF_TYPE_HEADER SetSeed2 ( std::vector<unsigned int> Seed2 ) { this->m_Seed2 = std::move(Seed2); return *this; }

      /**
       */
      std::vector<unsigned int> GetSeed2() const { return this->m_Seed2; }\

      /**
       * Set/Get the limit on the lower threshold value. The default is the NonpositiveMin() for the InputPixelType.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetLower ( double Lower ) { this->m_Lower = Lower; return *this; }

      /**
       * Set/Get the limit on the lower threshold value. The default is the NonpositiveMin() for the InputPixelType.
       */
      double GetLower() const { return this->m_Lower; }\

      /**
       * Set/Get the limit on the upper threshold value. The default is the max() for the InputPixelType.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetUpper ( double Upper ) { this->m_Upper = Upper; return *this; }

      /**
       * Set/Get the limit on the upper threshold value. The default is the max() for the InputPixelType.
       */
      double GetUpper() const { return this->m_Upper; }\

      /**
       * Set/Get value to replace thresholded pixels. Pixels that lie within the thresholds will be replaced with this value. The default is 1.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetReplaceValue ( uint8_t ReplaceValue ) { this->m_ReplaceValue = ReplaceValue; return *this; }

      /**
       * Set/Get value to replace thresholded pixels. Pixels that lie within the thresholds will be replaced with this value. The default is 1.
       */
      uint8_t GetReplaceValue() const { return this->m_ReplaceValue; }\

      /**
       * Set/Get the precision required for the intensity threshold value. The default is 1.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetIsolatedValueTolerance ( double IsolatedValueTolerance ) { this->m_IsolatedValueTolerance = IsolatedValueTolerance; return *this; }

      /**
       * Set/Get the precision required for the intensity threshold value. The default is 1.
       */
      double GetIsolatedValueTolerance() const { return this->m_IsolatedValueTolerance; }\

      /**
       * Set/Get whether to find an upper threshold (separating two dark regions) or a lower threshold (separating two bright regions).
       */
      SITK_RETURN_SELF_TYPE_HEADER SetFindUpperThreshold ( bool FindUpperThreshold ) { this->m_FindUpperThreshold = FindUpperThreshold; return *this; }

      /** Set the value of FindUpperThreshold to true or false respectfully. */
      SITK_RETURN_SELF_TYPE_HEADER FindUpperThresholdOn() { return this->SetFindUpperThreshold(true); }
      SITK_RETURN_SELF_TYPE_HEADER FindUpperThresholdOff() { return this->SetFindUpperThreshold(false); }

      /**
       * Set/Get whether to find an upper threshold (separating two dark regions) or a lower threshold (separating two bright regions).
       */
      bool GetFindUpperThreshold() const { return this->m_FindUpperThreshold; }
     /**
      * Get the flag that tells whether the algorithm failed to find a threshold.
      *
      * This is a measurement. Its value is updated in the Execute
      * methods, so the value will only be valid after an execution.
      */
     bool GetThresholdingFailed() const { return this->m_ThresholdingFailed; };

     /**
      * Get value that isolates the two seeds.
      *
      * This is a measurement. Its value is updated in the Execute
      * methods, so the value will only be valid after an execution.
      */
     double GetIsolatedValue() const { return this->m_IsolatedValue; };


      /** Name of this class */
      std::string GetName() const { return std::string ("IsolatedConnectedImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input image */

      Image Execute ( const Image& image1 );

    private:

      /** Setup for member function dispatching */

      using MemberFunctionType = Image (Self::*)( const Image& image1 );
      template <class TImageType> Image ExecuteInternal ( const Image& image1 );


      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;

      std::unique_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;


      std::vector<unsigned int>  m_Seed1{std::vector<unsigned int>(3, 0)};

      std::vector<unsigned int>  m_Seed2{std::vector<unsigned int>(3, 0)};

      double  m_Lower{0};

      double  m_Upper{1};

      uint8_t  m_ReplaceValue{1u};

      double  m_IsolatedValueTolerance{1.0};

      /*  */
      bool  m_FindUpperThreshold{true};


      bool m_ThresholdingFailed{false};

      double m_IsolatedValue{0.0};


    };

    /**\
     * \brief Label pixels that are connected to one set of seeds but not another.
     *
     * This function directly calls the execute method of IsolatedConnectedImageFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::IsolatedConnectedImageFilter for the object oriented interface
     * @{
     */

     SITKBasicFilters_EXPORT Image IsolatedConnected ( const Image& image1, std::vector<unsigned int> seed1 = std::vector<unsigned int>(3, 0), std::vector<unsigned int> seed2 = std::vector<unsigned int>(3, 0), double lower = 0, double upper = 1, uint8_t replaceValue = 1u, double isolatedValueTolerance = 1.0, bool findUpperThreshold = true );

     /** @} */
}
#endif
